/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.traits;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.library.materials.json.MaterialTraitsJson;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;

public class MaterialTraits {
    private final List<ModifierEntry> defaultTraits;
    private final Map<MaterialStatsId, List<ModifierEntry>> traitsPerStats;

    public boolean hasUniqueTraits(MaterialStatsId statsId) {
        return this.traitsPerStats.containsKey((Object)statsId);
    }

    public List<ModifierEntry> getTraits(MaterialStatsId statsId) {
        return this.traitsPerStats.getOrDefault((Object)statsId, this.defaultTraits);
    }

    public void write(FriendlyByteBuf buffer) {
        MaterialTraits.writeTraitList(buffer, this.defaultTraits);
        buffer.m_130130_(this.traitsPerStats.size());
        for (Map.Entry<MaterialStatsId, List<ModifierEntry>> entry : this.traitsPerStats.entrySet()) {
            buffer.m_130085_((ResourceLocation)entry.getKey());
            MaterialTraits.writeTraitList(buffer, entry.getValue());
        }
    }

    public static MaterialTraits read(FriendlyByteBuf buffer) {
        List<ModifierEntry> defaultTraits = MaterialTraits.readTraitList(buffer);
        int statTypeCount = buffer.m_130242_();
        HashMap<MaterialStatsId, List<ModifierEntry>> statsTraits = new HashMap<MaterialStatsId, List<ModifierEntry>>(statTypeCount);
        for (int i = 0; i < statTypeCount; ++i) {
            MaterialStatsId statsId = new MaterialStatsId(buffer.m_130281_());
            List<ModifierEntry> traitsList = MaterialTraits.readTraitList(buffer);
            statsTraits.put(statsId, traitsList);
        }
        return new MaterialTraits(defaultTraits, statsTraits);
    }

    private static List<ModifierEntry> readTraitList(FriendlyByteBuf buffer) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int count = buffer.m_130242_();
        for (int i = 0; i < count; ++i) {
            builder.add((Object)ModifierEntry.read(buffer));
        }
        return builder.build();
    }

    private static void writeTraitList(FriendlyByteBuf buffer, List<ModifierEntry> traits) {
        buffer.m_130130_(traits.size());
        for (ModifierEntry entry : traits) {
            entry.write(buffer);
        }
    }

    public MaterialTraits(List<ModifierEntry> defaultTraits, Map<MaterialStatsId, List<ModifierEntry>> traitsPerStats) {
        this.defaultTraits = defaultTraits;
        this.traitsPerStats = traitsPerStats;
    }

    public List<ModifierEntry> getDefaultTraits() {
        return this.defaultTraits;
    }

    protected Map<MaterialStatsId, List<ModifierEntry>> getTraitsPerStats() {
        return this.traitsPerStats;
    }

    public static class Builder {
        private List<ModifierEntry> defaultTraits = null;
        private final Map<MaterialStatsId, List<ModifierEntry>> traitsPerStats = new HashMap<MaterialStatsId, List<ModifierEntry>>();

        public void setDefaultTraits(@Nullable List<ModifierEntry> traits) {
            if (traits != null) {
                this.defaultTraits = traits;
            }
        }

        public void setTraits(MaterialStatsId statsId, @Nullable List<ModifierEntry> traits) {
            if (traits != null) {
                this.traitsPerStats.put(statsId, traits);
            } else {
                this.traitsPerStats.remove((Object)statsId);
            }
        }

        public MaterialTraitsJson serialize() {
            HashMap<MaterialStatsId, List<ModifierEntry>> newMap = null;
            if (!this.traitsPerStats.isEmpty()) {
                newMap = new HashMap<MaterialStatsId, List<ModifierEntry>>(this.traitsPerStats.size());
                newMap.putAll(this.traitsPerStats);
            }
            return new MaterialTraitsJson(this.defaultTraits, newMap);
        }

        public MaterialTraits build(Map<MaterialStatsId, MaterialStatsId> fallbacks) {
            ImmutableMap traitsPerStats;
            List<ModifierEntry> defaultTraits = this.defaultTraits;
            if (defaultTraits == null || defaultTraits.isEmpty()) {
                defaultTraits = Collections.emptyList();
            }
            if (this.traitsPerStats.isEmpty()) {
                traitsPerStats = Collections.emptyMap();
            } else {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.putAll(this.traitsPerStats);
                for (Map.Entry<MaterialStatsId, MaterialStatsId> fallback : fallbacks.entrySet()) {
                    List<ModifierEntry> fallbackTraits;
                    MaterialStatsId statType = fallback.getKey();
                    if (this.traitsPerStats.containsKey((Object)statType) || (fallbackTraits = this.traitsPerStats.get((Object)fallback.getValue())) == null) continue;
                    builder.put((Object)statType, fallbackTraits);
                }
                traitsPerStats = builder.build();
            }
            return new MaterialTraits(defaultTraits, (Map<MaterialStatsId, List<ModifierEntry>>)traitsPerStats);
        }

        @Deprecated
        public MaterialTraits build() {
            return this.build(Collections.emptyMap());
        }

        public List<ModifierEntry> getDefaultTraits() {
            return this.defaultTraits;
        }

        protected Map<MaterialStatsId, List<ModifierEntry>> getTraitsPerStats() {
            return this.traitsPerStats;
        }
    }
}

